<?php
// تنظیمات امنیتی
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
ini_set('log_errors', 1);

// فایل وب‌هوک برای تغییر وضعیت سفارش ووکامرس به همراه تخصیص لایسنس
require_once __DIR__ . '/../conf/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/main.php';

// دریافت داده POST
$content = file_get_contents("php://input");
$order = json_decode($content, true);
if(!$order || !isset($order['id']) || !isset($order['status'])) die('no order');

$order_id = $order['id'];
$user_mobile = $order['billing']['phone'] ?? '';
$user_mobile_norm = function_exists('normalizeMobile') ? normalizeMobile($user_mobile) : $user_mobile;

// تابع ارسال پیام به تلگرام
function sendTelegramMessage($chat_id, $text, $inline_keyboard = null) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if($inline_keyboard) {
        $data['reply_markup'] = json_encode($inline_keyboard);
    }
    file_get_contents('https://api.telegram.org/bot'.BOT_TOKEN.'/sendMessage?' . http_build_query($data));
}

// تابع تخصیص لایسنس
function assignLicenseToOrder($order_id, $user_mobile_norm, $line_items) {
    foreach($line_items as $item) {
        $product_id = $item['product_id'];
        $variation_id = $item['variation_id'] ?? 0;

        if($product_id && $variation_id) {
            $stmt = dbQuery("SELECT * FROM licenses WHERE product_id = ? AND variation_id = ? AND status = 'free' LIMIT 1", [$product_id, $variation_id]);
            if($lic = $stmt->fetch()) {
                // به‌روزرسانی لایسنس در دیتابیس
                dbQuery("UPDATE licenses SET status = 'assigned', assigned_to_order = ?, assigned_to_user = ?, assigned_at = NOW() WHERE id = ?", [$order_id, $user_mobile_norm, $lic['id']]);

                // افزودن یادداشت به سفارش در ووکامرس
                $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                $payload = json_encode([
                    'note' => "لایسنس شما: {$lic['license_key']}",
                    'customer_note' => true
                ]);
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Content-Length' => strlen($payload)
                ]);
                curl_exec($ch);
                curl_close($ch);

                // ارسال لایسنس به کاربر در تلگرام
                $stmt2 = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$user_mobile_norm]);
                if($row2 = $stmt2->fetch()) {
                    $msg = "🔔 لایسنس شما برای سفارش #{$order_id}:\n🚨 خبر داغ از گلدن چیت 🍾\n🎩 ساقی انواع چیت‌های ارجینال رسید خدمتتون 😌💼\n💉 دوز مخصوص امروز: لایسنس چیت خفن شما!\n\n🎮 🔑 <code>{$lic['license_key']}</code> 🔑 🎮\n\n🔥 با احتیاط مصرف شَوَد؛ ممکنه اعتیاد پیدا بکنی 😈😂\nاگه مشکلی بود، ساقی همیشه آنلاینه 💬📲";
                    sendTelegramMessage($row2['telegram_id'], $msg);
                }

                // تغییر وضعیت سفارش به completed
                $url_status = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                $payload_status = json_encode(['status' => 'completed']);
                $ch_status = curl_init($url_status);
                curl_setopt($ch_status, CURLOPT_CUSTOMREQUEST, "PUT");
                curl_setopt($ch_status, CURLOPT_POSTFIELDS, $payload_status);
                curl_setopt($ch_status, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch_status, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Content-Length' => strlen($payload_status)
                ]);
                curl_exec($ch_status);
                curl_close($ch_status);

                // ارسال پیام به ادمین‌ها مبنی بر ارسال لایسنس و تغییر وضعیت سفارش
                $product_name = $order['line_items'][0]['name'] ?? 'نامشخص';
                $buyer_name = trim(($order['billing']['first_name'] ?? '') . ' ' . ($order['billing']['last_name'] ?? ''));
                $admin_message = "✅ شماره سفارش: #{$order_id} | {$product_name} | {$buyer_name} با موفقیت لایسنس ارسال شد و وضعیت سفارش به تکمیل شده تغییر کرد.\n🔰 جزئییات سفارش:\nمحصول(ها): {$product_name}\nنام خریدار: {$buyer_name}\nوضعیت کاربر: عضو ربات است\nوضعیت: تکمیل شده\nلایسنس ارسالی: {$lic['license_key']}";

                // ارسال پیام فقط به ادمین اصلی
                sendTelegramMessage(ADMIN_ID, $admin_message);

                return true; // موفقیت در تخصیص لایسنس
            }
        }
    }
    return false; // لایسنس پیدا نشد
}

// فقط اگر وضعیت سفارش به processing تغییر کرد
if($order['status'] == 'processing') {

    // ارسال پیام هشدار اولیه به ادمین‌ها
    $products_info = [];
    foreach ($order['line_items'] as $item) {
        $name = $item['name'];
        $attrs = [];
        if (isset($item['meta_data']) && is_array($item['meta_data'])) {
            foreach ($item['meta_data'] as $meta) {
                if (!empty($meta['display_key']) && !empty($meta['display_value'])) {
                    $attrs[] = $meta['display_value'];
                }
            }
        }
        if ($attrs) {
            $name .= " (" . implode(' - ', $attrs) . ")";
        }
        $products_info[] = $name;
    }
    $products_str = implode('، ', $products_info);
    
    $status_map = [
        'processing' => 'در حال انجام',
        'completed' => 'تکمیل‌شده',
        'refunded' => 'مسترد شده',
        'pending' => 'در انتظار پرداخت'
    ];
    $status_fa = $status_map[$order['status']] ?? $order['status'];
    
    $stmt_user = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$user_mobile_norm]);
    $user_status = ($stmt_user->fetch()) ? 'عضو ربات است' : 'داخل ربات عضو نیست!!';

    $msg = "🔔 سفارش جدید یا تغییر وضعیت به در حال انجام:\n";
    $msg .= "شماره سفارش: #{$order_id}\n";
    $msg .= "محصول(ها): {$products_str}\n";
    $msg .= "نام خریدار: " . ($order['billing']['first_name'] . ' ' . $order['billing']['last_name']) . "\n";
    $msg .= "وضعیت کاربر: {$user_status}\n";
    $msg .= "وضعیت: {$status_fa}";

    $inline_keyboard = [
        'inline_keyboard' => [
            [ ['text' => 'مدیریت سفارش', 'callback_data' => 'admin_manageorder_' . $order_id] ]
        ]
    ];

    $stmt_admins = dbQuery("SELECT telegram_id FROM admins");
    while($row = $stmt_admins->fetch()) {
        sendTelegramMessage($row['telegram_id'], $msg, $inline_keyboard);
    }

    // بررسی شماره موبایل و عضویت در ربات
    if($user_mobile && $user_status == 'عضو ربات است') {
        $success = assignLicenseToOrder($order_id, $user_mobile_norm, $order['line_items']);
        if(!$success) {
            // اگر لایسنس پیدا نشد، اطلاع رسانی فقط به ادمین اصلی
            $alert_msg = "🚨⛔️ لایسنس برای سفارش #{$order_id} پیدا نشد! لطفاً پیگیری شود.";
            sendTelegramMessage(ADMIN_ID, $alert_msg);
        }
    }
}

echo 'ok';