<?php
require_once __DIR__ . '/../conf/config.php';
require_once __DIR__ . '/db.php';

define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');

function sendMessage($chat_id, $text, $reply_markup = null) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if($reply_markup) $data['reply_markup'] = json_encode($reply_markup);
    $result = @file_get_contents(API_URL . "sendMessage?" . http_build_query($data));
    file_put_contents('remind_log.txt', date('Y-m-d H:i:s')." | chat_id: $chat_id | result: $result\n", FILE_APPEND);
    $json = json_decode($result, true);
    return isset($json['ok']) && $json['ok'];
}

$sent = 0;
$error = 0;
$stmt = dbQuery("SELECT telegram_id FROM users WHERE (mobile IS NULL OR mobile = '')");
while($row = $stmt->fetch()) {
    $remind_keyboard = [
        'keyboard' => [
            [ ['text' => '📱 ارسال شماره من', 'request_contact' => true] ]
        ],
        'resize_keyboard' => true,
        'one_time_keyboard' => true
    ];
    $ok = sendMessage($row['telegram_id'], "📱 لطفاً شماره موبایل خود را با دکمه زیر ارسال کنید:\n\n⚠️ حتما از دکمه پایین یعنی 'ارسال شماره من' باید شماره خودتون رو ارسال بکنید\n\n❗️ نکته مهم اینکه اگه از داخل سایت سفارشی ثبت کردین باید و حتما همون شماره داخل تلگرام عضو بشین و با همون شماره اقدام بکنید هیچ راه دیگه ای وجود نداره", $remind_keyboard);
    if($ok === false) $error++;
    else $sent++;

    // اضافه کردن شرط برای پیام‌های غیرمجاز
    if(isset($update['message']) && isset($update['message']['chat']['id']) && $update['message']['chat']['id'] == $row['telegram_id']) {
        if(!isset($update['message']['contact'])) {
            sendMessage($row['telegram_id'], "⚠️ لطفاً فقط از دکمه 'ارسال شماره من' استفاده کنید. ارسال هرگونه پیام دیگر مجاز نیست.");
        }
    }
}

if(php_sapi_name() !== 'cli') {
    header('Content-Type: text/html; charset=utf-8');
    if($error > 0) {
        echo "<b>خطا در ارسال پیام به {$error} کاربر.</b><br>";
    }
    if($sent > 0) {
        echo "<b>پیام یادآوری با موفقیت برای {$sent} کاربر ارسال شد.</b>";
    } else if($error == 0) {
        echo "<b>کاربری بدون شماره موبایل یافت نشد.</b>";
    }
} 